#include <inttypes.h>
#ifdef __AVR__
#include <avr/pgmspace.h>
#elif defined (ESP8266)
#include <pgmspace.h>
#else
#define PROGMEM
#endif

#ifndef System_Min5x7_H
#define System_Min5x7_H

#define System_Min5x7_WIDTH 5
#define System_Min5x7_HEIGHT 7

const static uint8_t System_Min5x7[] PROGMEM = {
    0x0, 0x0, // size of zero indicates fixed width font, actual length is width * height
    0x05, // width
    0x07, // height
    0x20, // first char
    0x60, // char count
    
    // Fixed width; char width table not used !!!!
    
    // font data
		0x00, 0x00, 0x00, 0x00, 0x00,            // Code for char  
        0x00, 0x00, 0xBE, 0x00, 0x00,            // Code for char !
        0x00, 0x06, 0x00, 0x06, 0x00,            // Code for char "
        0x28, 0xFE, 0x28, 0xFE, 0x28,            // Code for char #
        0x48, 0x54, 0xFE, 0x54, 0x24,            // Code for char $
        0x46, 0x26, 0x10, 0xC8, 0xC4,            // Code for char %
        0x6C, 0x92, 0x6A, 0x64, 0x90,            // Code for char &
        0x00, 0x00, 0x06, 0x00, 0x00,            // Code for char '
        0x7C, 0x82, 0x00, 0x00, 0x00,            // Code for char (
        0x00, 0x00, 0x00, 0x82, 0x7C,            // Code for char )
        0x00, 0x04, 0x0E, 0x04, 0x00,            // Code for char *
        0x10, 0x10, 0x7C, 0x10, 0x10,            // Code for char +
        0x00, 0xA0, 0x60, 0x00, 0x00,            // Code for char ,
        0x10, 0x10, 0x10, 0x10, 0x10,            // Code for char -
        0x00, 0x00, 0x40, 0x00, 0x00,            // Code for char .
        0x40, 0x20, 0x10, 0x08, 0x04,            // Code for char /
        0x7C, 0xFE, 0x92, 0x8A, 0x7C,            // Code for char 0
        0x00, 0x84, 0xFE, 0xFE, 0x80,            // Code for char 1
        0xC2, 0xE2, 0x92, 0x9E, 0x8C,            // Code for char 2
        0x82, 0x92, 0x92, 0xFE, 0x6C,            // Code for char 3
        0x38, 0x24, 0xFE, 0xFE, 0x20,            // Code for char 4
        0x8E, 0x8A, 0x8A, 0xFA, 0x72,            // Code for char 5
        0x7C, 0xFE, 0x8A, 0x8A, 0x72,            // Code for char 6
        0x02, 0xF2, 0xFA, 0x0E, 0x06,            // Code for char 7
        0x6C, 0xFE, 0x92, 0x92, 0x6C,            // Code for char 8
        0x9C, 0xA2, 0xA2, 0xFE, 0x7C,            // Code for char 9
        0x00, 0x6C, 0x6C, 0x00, 0x00,            // Code for char :
        0x00, 0xAC, 0x6C, 0x00, 0x00,            // Code for char ;
        0x10, 0x28, 0x44, 0x82, 0x00,            // Code for char <
        0x28, 0x28, 0x28, 0x28, 0x28,            // Code for char =
        0x00, 0x82, 0x44, 0x28, 0x10,            // Code for char >
        0x04, 0x02, 0xA2, 0x12, 0x0C,            // Code for char ?
        0x1C, 0xB2, 0xB2, 0x82, 0x7C,            // Code for char @
        0xFC, 0xFE, 0x12, 0x12, 0xFC,            // Code for char A
        0xFE, 0xFE, 0x92, 0x92, 0x6C,            // Code for char B
        0x7C, 0xFE, 0x82, 0x82, 0x44,            // Code for char C
        0xFE, 0xFE, 0x82, 0x82, 0x7C,            // Code for char D
        0xFE, 0xFE, 0x92, 0x92, 0x82,            // Code for char E
        0xFE, 0xFE, 0x12, 0x12, 0x02,            // Code for char F
        0x7C, 0xFE, 0x82, 0x92, 0x74,            // Code for char G
        0xFE, 0xFE, 0x10, 0x10, 0xFE,            // Code for char H
        0x00, 0x82, 0xFE, 0xFE, 0x82,            // Code for char I
        0x40, 0x80, 0x82, 0xFE, 0x7E,            // Code for char J
        0xFE, 0xFE, 0x28, 0x44, 0x82,            // Code for char K
        0xFE, 0xFE, 0x80, 0x80, 0x80,            // Code for char L
        0xFE, 0xFC, 0x08, 0x04, 0xFE,            // Code for char M
        0xFE, 0xFE, 0x0C, 0x30, 0xFE,            // Code for char N
        0x7C, 0xFE, 0x82, 0x82, 0x7C,            // Code for char O
        0xFE, 0xFE, 0x12, 0x12, 0x0C,            // Code for char P
        0x7C, 0xFE, 0xA2, 0x42, 0xBC,            // Code for char Q
        0xFE, 0xFE, 0x32, 0x52, 0x8C,            // Code for char R
        0x4C, 0x9E, 0x92, 0xF2, 0x64,            // Code for char S
        0x02, 0xFE, 0xFE, 0x02, 0x02,            // Code for char T
        0x7E, 0xFE, 0x80, 0x80, 0x7E,            // Code for char U
        0x3E, 0x7E, 0x80, 0x40, 0x3E,            // Code for char V
        0x7E, 0xFE, 0x60, 0x80, 0x7E,            // Code for char W
        0xC6, 0xEE, 0x10, 0x28, 0xC6,            // Code for char X
        0x0E, 0x1E, 0xE0, 0xF0, 0x0E,            // Code for char Y
        0xE2, 0xF2, 0x9A, 0x8E, 0x86,            // Code for char Z
        0xFE, 0xFE, 0x82, 0x00, 0x00,            // Code for char [
        0x04, 0x08, 0x10, 0x20, 0x40,            // Code for char BackSlash
        0x00, 0x00, 0x82, 0xFE, 0xFE,            // Code for char ]
        0x08, 0x04, 0x02, 0x04, 0x08,            // Code for char ^
        0x80, 0x80, 0x80, 0x80, 0x80,            // Code for char _
        0x00, 0x00, 0x02, 0x04, 0x00,            // Code for char `
        0x40, 0xA8, 0xA8, 0xF8, 0xF0,            // Code for char a
        0xFE, 0x7E, 0x90, 0x90, 0x60,            // Code for char b
        0x70, 0xF8, 0x88, 0x88, 0x50,            // Code for char c
        0x60, 0x90, 0x90, 0x7E, 0xFE,            // Code for char d
        0x70, 0xF8, 0xA8, 0xA8, 0xB0,            // Code for char e
        0x10, 0xF8, 0xFC, 0x14, 0x04,            // Code for char f
        0x10, 0xA8, 0xA8, 0xF8, 0x78,            // Code for char g
        0xFE, 0xFE, 0x20, 0x10, 0xE0,            // Code for char h
        0x00, 0x88, 0xFA, 0xFA, 0x80,            // Code for char i
        0x40, 0x80, 0x88, 0xFA, 0x7A,            // Code for char j
        0xFE, 0xFE, 0x20, 0x50, 0x88,            // Code for char k
        0x00, 0x7E, 0xFE, 0x80, 0x80,            // Code for char l
        0xF8, 0x08, 0xF0, 0x08, 0xF0,            // Code for char m
        0xF8, 0xF8, 0x10, 0x08, 0xF0,            // Code for char n
        0x70, 0xF8, 0x88, 0x88, 0x70,            // Code for char o
        0xFC, 0xFC, 0x24, 0x24, 0x18,            // Code for char p
        0x18, 0x24, 0xFC, 0xFC, 0x80,            // Code for char q
        0xF8, 0xF8, 0x10, 0x08, 0x08,            // Code for char r
        0x90, 0xB8, 0xA8, 0xE8, 0x48,            // Code for char s
        0x10, 0x7C, 0xFC, 0x90, 0x00,            // Code for char t
        0x78, 0x80, 0x40, 0xF8, 0xF8,            // Code for char u
        0x38, 0x78, 0x80, 0x40, 0x38,            // Code for char v
        0x78, 0xF8, 0x40, 0x80, 0x78,            // Code for char w
        0x88, 0x50, 0x20, 0x50, 0x88,            // Code for char x
        0x18, 0xA0, 0xA0, 0xF8, 0x78,            // Code for char y
        0xC8, 0xE8, 0xA8, 0xB8, 0x98,            // Code for char z
        0x10, 0x6C, 0x82, 0x00, 0x00,            // Code for char {
        0x00, 0x00, 0xFE, 0x00, 0x00,            // Code for char |
        0x00, 0x00, 0x82, 0x6C, 0x10,            // Code for char }
        0x80, 0x40, 0x80, 0x40, 0x80             // Code for char ~
        };
#endif
